/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.queue;

import filenet.vw.api.VWException;
import filenet.vw.api.VWExposedFieldDefinition;
import filenet.vw.api.VWIndexDefinition;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWWorkBasketColumnDefinition;
import filenet.vw.api.VWWorkBasketDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.table.VWQubbleSort;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

class VWWorkBasketColumnTableModel
extends AbstractTableModel {
    private static final int NUM_COLUMNS = 4;
    protected static final int COL_FIELD = 0;
    protected static final int COL_PROMPT = 1;
    protected static final int COL_SORT_FLAG = 2;
    protected static final int COL_INDEX = 3;
    private VWSessionInfo m_sessionInfo = null;
    private boolean m_bDisplayIndexControls = true;
    private VWWorkBasketDefinition m_workBasketDef = null;
    private VWQueueDefinition m_queueDef = null;
    private Vector m_rowData = null;
    private boolean m_bIsModified = false;

    public VWWorkBasketColumnTableModel(VWSessionInfo sessionInfo, boolean bDisplayIndexControls) {
        this.m_sessionInfo = sessionInfo;
        this.m_bDisplayIndexControls = bDisplayIndexControls;
        this.m_rowData = new Vector();
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return VWExposedFieldDefinition.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return Boolean.class;
            }
            case 3: {
                return VWIndexDefinition.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        if (!this.m_bDisplayIndexControls) {
            return 3;
        }
        return 4;
    }

    public String getColumnName(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return VWResource.SelectedFields;
            }
            case 1: {
                return VWResource.ColumnLabel;
            }
            case 2: {
                return VWResource.Sortable;
            }
            case 3: {
                return VWResource.ContentOrder;
            }
        }
        return null;
    }

    public int getRowCount() {
        return this.m_rowData.size();
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        try {
            VWWorkBasketColumnDefinition workBasketColumnDef = this.getRowItemAt(nRowIndex);
            switch (nColumnIndex) {
                case 0: {
                    if (workBasketColumnDef == null) break;
                    return workBasketColumnDef.getColumn();
                }
                case 1: {
                    if (workBasketColumnDef == null) break;
                    return workBasketColumnDef.getPrompt();
                }
                case 2: {
                    if (workBasketColumnDef == null) break;
                    return workBasketColumnDef.isSortable();
                }
                case 3: {
                    if (workBasketColumnDef == null) break;
                    String indexName = workBasketColumnDef.getIndexName();
                    if (indexName != null) {
                        try {
                            if (this.m_queueDef != null) {
                                return this.m_queueDef.getIndex(indexName);
                            }
                        }
                        catch (VWException ex) {
                            workBasketColumnDef.setIndexName(null);
                        }
                    }
                    return VWResource.s_none;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        try {
            switch (nColumnIndex) {
                case 0: {
                    return false;
                }
                case 1: {
                    return true;
                }
                case 2: {
                    return this.m_bDisplayIndexControls;
                }
                case 3: {
                    VWWorkBasketColumnDefinition workBasketColumnDef = this.getRowItemAt(nRowIndex);
                    return workBasketColumnDef.isSortable();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return false;
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        try {
            switch (nColumnIndex) {
                case 1: {
                    this.onUpdatePrompt(aValue, nRowIndex);
                    break;
                }
                case 2: {
                    this.onUpdateSortFlag(aValue, nRowIndex);
                    break;
                }
                case 3: {
                    this.onUpdateIndexName(aValue, nRowIndex);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_sessionInfo.getParentFrame(), ex.getLocalizedMessage(), 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setWorkBasketDefinition(VWWorkBasketDefinition workBasketDef) {
        try {
            try {
                VWWorkBasketColumnDefinition[] workBasketColumnDefs;
                this.m_workBasketDef = workBasketDef;
                this.m_rowData = new Vector();
                if (this.m_workBasketDef != null && (workBasketColumnDefs = this.m_workBasketDef.getWorkBasketColumnDefinitions()) != null) {
                    for (int nIndex = 0; nIndex < workBasketColumnDefs.length; ++nIndex) {
                        this.m_rowData.addElement(workBasketColumnDefs[nIndex]);
                    }
                }
                Object var5_5 = null;
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                Object var5_6 = null;
                this.fireTableDataChanged();
                this.m_bIsModified = false;
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.fireTableDataChanged();
            this.m_bIsModified = false;
            throw throwable;
        }
        this.fireTableDataChanged();
        this.m_bIsModified = false;
    }

    protected void setQueueDefinition(VWQueueDefinition queueDef) {
        this.m_queueDef = queueDef;
        this.setWorkBasketDefinition(null);
    }

    protected void addNewWorkBasketColumn(VWExposedFieldDefinition fieldDef) throws Exception {
        VWWorkBasketColumnDefinition newWorkBasketColumnDef = this.m_workBasketDef.createWorkBasketColumnDefinition(null, fieldDef);
        this.m_rowData.addElement(newWorkBasketColumnDef);
        this.m_bIsModified = true;
        int nLastRow = this.getRowCount() - 1;
        this.fireTableRowsInserted(nLastRow, nLastRow);
    }

    protected void moveWorkBasketColumnUp(int nRowIndex) throws Exception {
        if (nRowIndex > 0 && this.getRowCount() > 0) {
            VWWorkBasketColumnDefinition workBasketColumnDef = this.getRowItemAt(nRowIndex);
            this.m_rowData.removeElement(workBasketColumnDef);
            this.m_rowData.insertElementAt(workBasketColumnDef, nRowIndex - 1);
            Object[] columnDefs = new VWWorkBasketColumnDefinition[this.m_rowData.size()];
            this.m_rowData.copyInto(columnDefs);
            this.m_workBasketDef.setWorkBasketColumnDefinitions((VWWorkBasketColumnDefinition[])columnDefs);
            this.m_bIsModified = true;
            this.fireTableRowsUpdated(nRowIndex - 1, nRowIndex);
        }
    }

    protected void moveWorkBasketColumnDown(int nRowIndex) throws Exception {
        if (nRowIndex < this.getRowCount() - 1) {
            VWWorkBasketColumnDefinition workBasketColumnDef = this.getRowItemAt(nRowIndex);
            this.m_rowData.removeElement(workBasketColumnDef);
            this.m_rowData.insertElementAt(workBasketColumnDef, nRowIndex + 1);
            Object[] columnDefs = new VWWorkBasketColumnDefinition[this.m_rowData.size()];
            this.m_rowData.copyInto(columnDefs);
            this.m_workBasketDef.setWorkBasketColumnDefinitions((VWWorkBasketColumnDefinition[])columnDefs);
            this.m_bIsModified = true;
            this.fireTableRowsUpdated(nRowIndex, nRowIndex + 1);
        }
    }

    protected void deleteWorkBasketColumnAtIndex(int nRowIndex) {
        try {
            VWWorkBasketColumnDefinition workBasketColumnDef = this.getRowItemAt(nRowIndex);
            this.m_workBasketDef.deleteWorkBasketColumnDefinition(workBasketColumnDef.getName());
            this.m_rowData.removeElement(workBasketColumnDef);
            this.m_bIsModified = true;
            this.fireTableRowsDeleted(nRowIndex, nRowIndex);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_sessionInfo.getParentFrame(), ex.getLocalizedMessage(), 1);
        }
    }

    public VWExposedFieldDefinition[] getSelectedFields() {
        try {
            if (this.m_rowData != null && this.m_rowData.size() > 0) {
                Object[] selectedFields = new VWExposedFieldDefinition[this.m_rowData.size()];
                for (int nRowIndex = 0; nRowIndex < this.m_rowData.size(); ++nRowIndex) {
                    VWWorkBasketColumnDefinition columnDef = this.getRowItemAt(nRowIndex);
                    selectedFields[nRowIndex] = columnDef.getColumn();
                }
                VWQubbleSort.sort(selectedFields);
                return selectedFields;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    protected VWWorkBasketColumnDefinition getRowItemAt(int nRowIndex) {
        if (this.m_rowData == null || nRowIndex < 0 || nRowIndex > this.m_rowData.size()) {
            return null;
        }
        if (nRowIndex < this.m_rowData.size()) {
            return (VWWorkBasketColumnDefinition)this.m_rowData.elementAt(nRowIndex);
        }
        return null;
    }

    protected boolean isModified() {
        return this.m_bIsModified;
    }

    protected void resetModifiedFlag() {
        this.m_bIsModified = false;
    }

    protected void releaseResources() {
        if (this.m_rowData != null) {
            this.m_rowData.removeAllElements();
            this.m_rowData = null;
        }
        this.m_workBasketDef = null;
    }

    private void onUpdatePrompt(Object aValue, int nRowIndex) throws Exception {
        String newPrompt;
        if (aValue == null || !(aValue instanceof String)) {
            return;
        }
        VWWorkBasketColumnDefinition workBasketColumnDef = this.getRowItemAt(nRowIndex);
        if (workBasketColumnDef != null && VWStringUtils.compare(newPrompt = (String)aValue, workBasketColumnDef.getPrompt()) != 0) {
            workBasketColumnDef.setPrompt(newPrompt);
            this.m_bIsModified = true;
            this.fireTableCellUpdated(nRowIndex, 1);
        }
    }

    private void onUpdateSortFlag(Object aValue, int nRowIndex) throws Exception {
        boolean bIsSortable;
        if (aValue == null || !(aValue instanceof Boolean)) {
            return;
        }
        VWWorkBasketColumnDefinition workBasketColumnDef = this.getRowItemAt(nRowIndex);
        if (workBasketColumnDef != null && (bIsSortable = ((Boolean)aValue).booleanValue()) != workBasketColumnDef.isSortable()) {
            workBasketColumnDef.setSortable(bIsSortable);
            this.m_bIsModified = true;
            this.fireTableCellUpdated(nRowIndex, 2);
            if (!bIsSortable) {
                workBasketColumnDef.setIndexName(null);
                this.fireTableCellUpdated(nRowIndex, 3);
            }
        }
    }

    private void onUpdateIndexName(Object aValue, int nRowIndex) throws Exception {
        VWIndexDefinition newIndexDef;
        if (aValue == null || !(aValue instanceof VWIndexDefinition)) {
            return;
        }
        VWWorkBasketColumnDefinition workBasketColumnDef = this.getRowItemAt(nRowIndex);
        if (workBasketColumnDef != null && VWStringUtils.compare((newIndexDef = (VWIndexDefinition)aValue).getName(), workBasketColumnDef.getIndexName()) != 0) {
            workBasketColumnDef.setIndexName(newIndexDef.getName());
            this.m_bIsModified = true;
            this.fireTableCellUpdated(nRowIndex, 3);
        }
    }
}

